// To parse this JSON data, do
//
//     final meetingStatusModel = meetingStatusModelFromJson(jsonString);

import 'dart:convert';

MeetingStatusModel meetingStatusModelFromJson(String str) =>
    MeetingStatusModel.fromJson(json.decode(str));

String meetingStatusModelToJson(MeetingStatusModel data) =>
    json.encode(data.toJson());

class MeetingStatusModel {
  List<Result>? result;

  MeetingStatusModel({
    this.result,
  });

  factory MeetingStatusModel.fromJson(Map<String, dynamic> json) =>
      MeetingStatusModel(
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  String? name;
  int? value;

  Result({
    this.name,
    this.value,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        name: json["name"],
        value: json["value"],
      );

  Map<String, dynamic> toJson() => {
        "name": name,
        "value": value,
      };
}
