// To parse this JSON data, do
//
//     final meetingListModel = meetingListModelFromJson(jsonString);

import 'dart:convert';

MeetingListModel meetingListModelFromJson(String str) =>
    MeetingListModel.fromJson(json.decode(str));

String meetingListModelToJson(MeetingListModel data) =>
    json.encode(data.toJson());

class MeetingListModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  MeetingListModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory MeetingListModel.fromJson(Map<String, dynamic> json) =>
      MeetingListModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  String? title;
  int? tutorId;
  int? platformId;
  String? meetingLink;
  int? isFree;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? platformName;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  String? avgRating;

  Result({
    this.id,
    this.title,
    this.tutorId,
    this.platformId,
    this.meetingLink,
    this.isFree,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.platformName,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.avgRating,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        title: json["title"],
        tutorId: json["tutor_id"],
        platformId: json["platform_id"],
        meetingLink: json["meeting_link"],
        isFree: json["is_free"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        platformName: json["platform_name"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        avgRating: json["avg_rating"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "title": title,
        "tutor_id": tutorId,
        "platform_id": platformId,
        "meeting_link": meetingLink,
        "is_free": isFree,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "platform_name": platformName,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "avg_rating": avgRating,
      };
}
