// To parse this JSON data, do
//
//     final meetingDetailsModel = meetingDetailsModelFromJson(jsonString);

import 'dart:convert';

MeetingDetailsModel meetingDetailsModelFromJson(String str) =>
    MeetingDetailsModel.fromJson(json.decode(str));

String meetingDetailsModelToJson(MeetingDetailsModel data) =>
    json.encode(data.toJson());

class MeetingDetailsModel {
  int? status;
  String? message;
  List<Result>? result;

  MeetingDetailsModel({
    this.status,
    this.message,
    this.result,
  });

  factory MeetingDetailsModel.fromJson(Map<String, dynamic> json) =>
      MeetingDetailsModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  String? title;
  int? tutorId;
  int? platformId;
  String? meetingLink;
  int? isFree;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? platformName;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  List<MettingSchedule>? mettingSchedule;

  Result({
    this.id,
    this.title,
    this.tutorId,
    this.platformId,
    this.meetingLink,
    this.isFree,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.platformName,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.mettingSchedule,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        title: json["title"],
        tutorId: json["tutor_id"],
        platformId: json["platform_id"],
        meetingLink: json["meeting_link"],
        isFree: json["is_free"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        platformName: json["platform_name"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        mettingSchedule: json["metting_schedule"] == null
            ? []
            : List<MettingSchedule>.from(json["metting_schedule"]!
                .map((x) => MettingSchedule.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "title": title,
        "tutor_id": tutorId,
        "platform_id": platformId,
        "meeting_link": meetingLink,
        "is_free": isFree,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "platform_name": platformName,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "metting_schedule": mettingSchedule == null
            ? []
            : List<dynamic>.from(mettingSchedule!.map((x) => x.toJson())),
      };
}

class MettingSchedule {
  List<Date>? date;

  MettingSchedule({
    this.date,
  });

  factory MettingSchedule.fromJson(Map<String, dynamic> json) =>
      MettingSchedule(
        date: json["date"] == null
            ? []
            : List<Date>.from(json["date"]!.map((x) => Date.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "date": date == null
            ? []
            : List<dynamic>.from(date!.map((x) => x.toJson())),
      };
}

class Date {
  int? id;
  int? mettingId;
  String? date;
  String? startTime;
  String? endTime;
  String? timeDuration;
  int? status;
  String? createdAt;
  String? updatedAt;

  Date({
    this.id,
    this.mettingId,
    this.date,
    this.startTime,
    this.endTime,
    this.timeDuration,
    this.status,
    this.createdAt,
    this.updatedAt,
  });

  factory Date.fromJson(Map<String, dynamic> json) => Date(
        id: json["id"],
        mettingId: json["metting_id"],
        date: json["date"],
        startTime: json["start_time"],
        endTime: json["end_time"],
        timeDuration: json["time_duration"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "metting_id": mettingId,
        "date": date,
        "start_time": startTime,
        "end_time": endTime,
        "time_duration": timeDuration,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
      };
}
