// To parse this JSON data, do
//
//     final liveClassSectionModel = liveClassSectionModelFromJson(jsonString);

import 'dart:convert';

LiveClassSectionModel liveClassSectionModelFromJson(String str) =>
    LiveClassSectionModel.fromJson(json.decode(str));

String liveClassSectionModelToJson(LiveClassSectionModel data) =>
    json.encode(data.toJson());

class LiveClassSectionModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  LiveClassSectionModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory LiveClassSectionModel.fromJson(Map<String, dynamic> json) =>
      LiveClassSectionModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  String? title;
  String? shortTitle;
  int? type;
  String? liveClassStatus;
  String? screenLayout;
  int? orderByUpload;
  int? sortable;
  int? status;
  String? createdAt;
  String? updatedAt;
  List<Datum>? data;

  Result({
    this.id,
    this.title,
    this.shortTitle,
    this.type,
    this.liveClassStatus,
    this.screenLayout,
    this.orderByUpload,
    this.sortable,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.data,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        title: json["title"],
        shortTitle: json["short_title"],
        type: json["type"],
        liveClassStatus: json["live_class_status"],
        screenLayout: json["screen_layout"],
        orderByUpload: json["order_by_upload"],
        sortable: json["sortable"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        data: json["data"] == null
            ? []
            : List<Datum>.from(json["data"]!.map((x) => Datum.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "title": title,
        "short_title": shortTitle,
        "type": type,
        "live_class_status": liveClassStatus,
        "screen_layout": screenLayout,
        "order_by_upload": orderByUpload,
        "sortable": sortable,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "data": data == null
            ? []
            : List<dynamic>.from(data!.map((x) => x.toJson())),
      };
}

class Datum {
  int? id;
  int? type;
  int? typeId;
  int? courseId;
  String? title;
  String? description;
  DateTime? startedDate;
  String? startTime;
  String? endTime;
  String? meetingLink;
  int? platformId;
  int? isFree;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  String? categoryName;
  String? courseTitle;
  String? courseImage;
  String? platformName;
  int? isUserBuy;
  String? timeDuration;
  String? recordingUrl;

  Datum({
    this.id,
    this.type,
    this.typeId,
    this.courseId,
    this.title,
    this.description,
    this.startedDate,
    this.startTime,
    this.endTime,
    this.meetingLink,
    this.platformId,
    this.isFree,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.categoryName,
    this.courseTitle,
    this.courseImage,
    this.platformName,
    this.isUserBuy,
    this.timeDuration,
    this.recordingUrl,
  });

  factory Datum.fromJson(Map<String, dynamic> json) => Datum(
        id: json["id"],
        type: json["type"],
        typeId: json["type_id"],
        courseId: json["course_id"],
        title: json["title"],
        description: json["description"],
        startedDate: json["started_date"] == null
            ? null
            : DateTime.parse(json["started_date"]),
        startTime: json["start_time"],
        endTime: json["end_time"],
        meetingLink: json["meeting_link"],
        platformId: json["platform_id"],
        isFree: json["is_free"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        categoryName: json["category_name"],
        courseTitle: json["course_title"],
        courseImage: json["course_image"],
        platformName: json["platform_name"],
        isUserBuy: json["is_user_buy"],
        timeDuration: json["time_duration"],
        recordingUrl: json["recording_url"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "type": type,
        "type_id": typeId,
        "course_id": courseId,
        "title": title,
        "description": description,
        "started_date":
            "${startedDate!.year.toString().padLeft(4, '0')}-${startedDate!.month.toString().padLeft(2, '0')}-${startedDate!.day.toString().padLeft(2, '0')}",
        "start_time": startTime,
        "end_time": endTime,
        "meeting_link": meetingLink,
        "platform_id": platformId,
        "is_free": isFree,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "category_name": categoryName,
        "course_title": courseTitle,
        "course_image": courseImage,
        "platform_name": platformName,
        "is_user_buy": isUserBuy,
        "time_duration": timeDuration,
        "recording_url": recordingUrl,
      };
}
