// To parse this JSON data, do
//
//     final courseNameModel = courseNameModelFromJson(jsonString);

import 'dart:convert';

CourseNameModel courseNameModelFromJson(String str) =>
    CourseNameModel.fromJson(json.decode(str));

String courseNameModelToJson(CourseNameModel data) =>
    json.encode(data.toJson());

class CourseNameModel {
  int? status;
  String? message;
  List<Result>? result;

  CourseNameModel({
    this.status,
    this.message,
    this.result,
  });

  factory CourseNameModel.fromJson(Map<String, dynamic> json) =>
      CourseNameModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  String? title;

  Result({
    this.id,
    this.title,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        title: json["title"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "title": title,
      };
}
