// To parse this JSON data, do
//
//     final classHistoryModel = classHistoryModelFromJson(jsonString);

import 'dart:convert';

ClassHistoryModel classHistoryModelFromJson(String str) =>
    ClassHistoryModel.fromJson(json.decode(str));

String classHistoryModelToJson(ClassHistoryModel data) =>
    json.encode(data.toJson());

class ClassHistoryModel {
  int? status;
  String? message;
  List<Result>? result;
  int? totalRows;
  int? totalPage;
  int? currentPage;
  bool? morePage;

  ClassHistoryModel({
    this.status,
    this.message,
    this.result,
    this.totalRows,
    this.totalPage,
    this.currentPage,
    this.morePage,
  });

  factory ClassHistoryModel.fromJson(Map<String, dynamic> json) =>
      ClassHistoryModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
        totalRows: json["total_rows"],
        totalPage: json["total_page"],
        currentPage: json["current_page"],
        morePage: json["more_page"],
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
        "total_rows": totalRows,
        "total_page": totalPage,
        "current_page": currentPage,
        "more_page": morePage,
      };
}

class Result {
  int? id;
  int? userId;
  int? liveClassId;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? liveClassTitle;
  String? categoryName;
  int? isFree;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;

  Result({
    this.id,
    this.userId,
    this.liveClassId,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.liveClassTitle,
    this.categoryName,
    this.isFree,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userId: json["user_id"],
        liveClassId: json["live_class_id"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        liveClassTitle: json["live_class_title"],
        categoryName: json["category_name"],
        isFree: json["is_free"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "live_class_id": liveClassId,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "live_class_title": liveClassTitle,
        "category_name": categoryName,
        "is_free": isFree,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
      };
}
