// To parse this JSON data, do
//
//     final classHistoryDetailsModel = classHistoryDetailsModelFromJson(jsonString);

import 'dart:convert';

ClassHistoryDetailsModel classHistoryDetailsModelFromJson(String str) =>
    ClassHistoryDetailsModel.fromJson(json.decode(str));

String classHistoryDetailsModelToJson(ClassHistoryDetailsModel data) =>
    json.encode(data.toJson());

class ClassHistoryDetailsModel {
  int? status;
  String? message;
  List<Result>? result;

  ClassHistoryDetailsModel({
    this.status,
    this.message,
    this.result,
  });

  factory ClassHistoryDetailsModel.fromJson(Map<String, dynamic> json) =>
      ClassHistoryDetailsModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  int? userId;
  int? liveClassId;
  int? status;
  String? createdAt;
  String? updatedAt;
  LiveClass? liveClass;

  Result({
    this.id,
    this.userId,
    this.liveClassId,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.liveClass,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userId: json["user_id"],
        liveClassId: json["live_class_id"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        liveClass: json["live_class"] == null
            ? null
            : LiveClass.fromJson(json["live_class"]),
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "live_class_id": liveClassId,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "live_class": liveClass?.toJson(),
      };
}

class LiveClass {
  int? id;
  int? type;
  int? typeId;
  int? courseId;
  String? title;
  String? description;
  DateTime? startedDate;
  String? startTime;
  String? endTime;
  String? meetingLink;
  int? platformId;
  int? isFree;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? lecturerName;
  String? lecturerUserName;
  String? lecturerImage;
  String? courseTitle;
  String? courseThumbnailImg;
  String? courseLandscapeImg;

  LiveClass({
    this.id,
    this.type,
    this.typeId,
    this.courseId,
    this.title,
    this.description,
    this.startedDate,
    this.startTime,
    this.endTime,
    this.meetingLink,
    this.platformId,
    this.isFree,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.lecturerName,
    this.lecturerUserName,
    this.lecturerImage,
    this.courseTitle,
    this.courseThumbnailImg,
    this.courseLandscapeImg,
  });

  factory LiveClass.fromJson(Map<String, dynamic> json) => LiveClass(
        id: json["id"],
        type: json["type"],
        typeId: json["type_id"],
        courseId: json["course_id"],
        title: json["title"],
        description: json["description"],
        startedDate: json["started_date"] == null
            ? null
            : DateTime.parse(json["started_date"]),
        startTime: json["start_time"],
        endTime: json["end_time"],
        meetingLink: json["meeting_link"],
        platformId: json["platform_id"],
        isFree: json["is_free"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        lecturerName: json["lecturer_name"],
        lecturerUserName: json["lecturer_user_name"],
        lecturerImage: json["lecturer_image"],
        courseTitle: json["course_title"],
        courseThumbnailImg: json["course_thumbnail_img"],
        courseLandscapeImg: json["course_landscape_img"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "type": type,
        "type_id": typeId,
        "course_id": courseId,
        "title": title,
        "description": description,
        "started_date":
            "${startedDate!.year.toString().padLeft(4, '0')}-${startedDate!.month.toString().padLeft(2, '0')}-${startedDate!.day.toString().padLeft(2, '0')}",
        "start_time": startTime,
        "end_time": endTime,
        "meeting_link": meetingLink,
        "platform_id": platformId,
        "is_free": isFree,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "lecturer_name": lecturerName,
        "lecturer_user_name": lecturerUserName,
        "lecturer_image": lecturerImage,
        "course_title": courseTitle,
        "course_thumbnail_img": courseThumbnailImg,
        "course_landscape_img": courseLandscapeImg,
      };
}
