// To parse this JSON data, do
//
//     final chapterNameModel = chapterNameModelFromJson(jsonString);

import 'dart:convert';

ChapterNameModel chapterNameModelFromJson(String str) => ChapterNameModel.fromJson(json.decode(str));

String chapterNameModelToJson(ChapterNameModel data) => json.encode(data.toJson());

class ChapterNameModel {
    int? status;
    String? message;
    List<Result>? result;

    ChapterNameModel({
        this.status,
        this.message,
        this.result,
    });

    factory ChapterNameModel.fromJson(Map<String, dynamic> json) => ChapterNameModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null ? [] : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null ? [] : List<dynamic>.from(result!.map((x) => x.toJson())),
    };
}

class Result {
    int? id;
    String? name;

    Result({
        this.id,
        this.name,
    });

    factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        name: json["name"],
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "name": name,
    };
}
