// To parse this JSON data, do
//
//     final cartModel = cartModelFromJson(jsonString);

import 'dart:convert';

CartModel cartModelFromJson(String str) => CartModel.fromJson(json.decode(str));

String cartModelToJson(CartModel data) => json.encode(data.toJson());

class CartModel {
  int? status;
  String? message;
  List<Result>? result;

  CartModel({
    this.status,
    this.message,
    this.result,
  });

  factory CartModel.fromJson(Map<String, dynamic> json) => CartModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? id;
  int? userId;
  int? courseId;
  int? price;
  int? status;
  String? createdAt;
  String? updatedAt;
  String? courseTitle;
  String? courseImage;
  String? courseAvgRating;
  int? totalChapter;
  dynamic totalVideoDuration;

  Result({
    this.id,
    this.userId,
    this.courseId,
    this.price,
    this.status,
    this.createdAt,
    this.updatedAt,
    this.courseTitle,
    this.courseImage,
    this.courseAvgRating,
    this.totalChapter,
    this.totalVideoDuration,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        userId: json["user_id"],
        courseId: json["course_id"],
        price: json["price"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        courseTitle: json["course_title"],
        courseImage: json["course_image"],
        courseAvgRating: json["course_avg_rating"],
        totalChapter: json["total_chapter"],
        totalVideoDuration: json["total_video_duration"],
      );

  Map<String, dynamic> toJson() => {
        "id": id,
        "user_id": userId,
        "course_id": courseId,
        "price": price,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "course_title": courseTitle,
        "course_image": courseImage,
        "course_avg_rating": courseAvgRating,
        "total_chapter": totalChapter,
        "total_video_duration": totalVideoDuration,
      };
}
