// To parse this JSON data, do
//
//     final blogDetailModel = blogDetailModelFromJson(jsonString);

import 'dart:convert';

BlogDetailModel blogDetailModelFromJson(String str) => BlogDetailModel.fromJson(json.decode(str));

String blogDetailModelToJson(BlogDetailModel data) => json.encode(data.toJson());

class BlogDetailModel {
    int? status;
    String? message;
    List<Result>? result;

    BlogDetailModel({
        this.status,
        this.message,
        this.result,
    });

    factory BlogDetailModel.fromJson(Map<String, dynamic> json) => BlogDetailModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null ? [] : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
    );

    Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null ? [] : List<dynamic>.from(result!.map((x) => x.toJson())),
    };
}

class Result {
    int? id;
    int? tutorId;
    String? title;
    String? description;
    String? image;
    int? totalView;
    int? status;
    String? createdAt;
    String? updatedAt;
    String? tutorName;
    int? isWishlist;

    Result({
        this.id,
        this.tutorId,
        this.title,
        this.description,
        this.image,
        this.totalView,
        this.status,
        this.createdAt,
        this.updatedAt,
        this.tutorName,
        this.isWishlist,
    });

    factory Result.fromJson(Map<String, dynamic> json) => Result(
        id: json["id"],
        tutorId: json["tutor_id"],
        title: json["title"],
        description: json["description"],
        image: json["image"],
        totalView: json["total_view"],
        status: json["status"],
        createdAt: json["created_at"],
        updatedAt: json["updated_at"],
        tutorName: json["tutor_name"],
        isWishlist: json["is_wishlist"],
    );

    Map<String, dynamic> toJson() => {
        "id": id,
        "tutor_id": tutorId,
        "title": title,
        "description": description,
        "image": image,
        "total_view": totalView,
        "status": status,
        "created_at": createdAt,
        "updated_at": updatedAt,
        "tutor_name": tutorName,
        "is_wishlist": isWishlist,
    };
}
