// To parse this JSON data, do
//
//     final applyCouponModel = applyCouponModelFromJson(jsonString);

import 'dart:convert';

ApplyCouponModel applyCouponModelFromJson(String str) =>
    ApplyCouponModel.fromJson(json.decode(str));

String applyCouponModelToJson(ApplyCouponModel data) =>
    json.encode(data.toJson());

class ApplyCouponModel {
  int? status;
  String? message;
  List<Result>? result;

  ApplyCouponModel({
    this.status,
    this.message,
    this.result,
  });

  factory ApplyCouponModel.fromJson(Map<String, dynamic> json) =>
      ApplyCouponModel(
        status: json["status"],
        message: json["message"],
        result: json["result"] == null
            ? []
            : List<Result>.from(json["result"]!.map((x) => Result.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "status": status,
        "message": message,
        "result": result == null
            ? []
            : List<dynamic>.from(result!.map((x) => x.toJson())),
      };
}

class Result {
  int? totalPrice;
  int? price;
  int? discountAmount;

  Result({
    this.totalPrice,
    this.price,
    this.discountAmount,
  });

  factory Result.fromJson(Map<String, dynamic> json) => Result(
        totalPrice: json["total_price"],
        price: json["price"],
        discountAmount: json["discount_amount"],
      );

  Map<String, dynamic> toJson() => {
        "total_price": totalPrice,
        "price": price,
        "discount_amount": discountAmount,
      };
}
