import 'dart:ui';
import 'package:prakah/provider/appoinmentbookingprovider.dart';
import 'package:prakah/provider/cartprovider.dart';
import 'package:prakah/provider/couponprovider.dart';
import 'package:prakah/provider/feedbackprovider.dart';
import 'package:prakah/provider/liveclassprovider.dart';
import 'package:prakah/provider/meetingdetailsprovider.dart';
import 'package:prakah/provider/meetingprovider.dart';
import 'package:prakah/provider/mywalletprovider.dart';
import 'package:prakah/provider/profileeditprovider.dart';
import 'package:prakah/provider/transcationlistprovider.dart';
import 'package:prakah/provider/videobyidviewallprovider.dart';
import 'package:prakah/provider/viewdetailsprovider.dart';
import 'package:prakah/provider/viewseriesprovider.dart';
import 'package:hive/hive.dart';
import 'package:path_provider/path_provider.dart';
import 'package:prakah/firebase_options.dart';
import 'package:prakah/model/download_item.dart';
import 'package:prakah/pages/splash.dart';
import 'package:prakah/provider/blogdetailprovider.dart';
import 'package:prakah/provider/coursedetailsprovider.dart';
import 'package:prakah/provider/tutorprofileprovider.dart';
import 'package:prakah/provider/ebookdetailprovider.dart';
import 'package:prakah/provider/ebookprovider.dart';
import 'package:prakah/provider/generalprovider.dart';
import 'package:prakah/provider/homeprovider.dart';
import 'package:prakah/provider/mycourseprovider.dart';
import 'package:prakah/provider/notificationprovider.dart';
import 'package:prakah/provider/playerprovider.dart';
import 'package:prakah/provider/profileprovider.dart';
import 'package:prakah/provider/quizeprovider.dart';
import 'package:prakah/provider/exploreprovider.dart';
import 'package:prakah/provider/readbookprovider.dart';
import 'package:prakah/provider/searchprovider.dart';
import 'package:prakah/provider/showdownloadprovider.dart';
import 'package:prakah/provider/subscriptionprovider.dart';
import 'package:prakah/provider/themeprovider.dart';
import 'package:prakah/provider/videodownloadprovider.dart';
import 'package:prakah/provider/viewallprovider.dart';
import 'package:prakah/provider/wishlistprovider.dart';
import 'package:prakah/utils/color.dart';
import 'package:prakah/utils/constant.dart';
import 'package:prakah/utils/sharedpre.dart';
import 'package:prakah/utils/utils.dart';
import 'package:prakah/webpages/webhome.dart';
import 'package:firebase_core/firebase_core.dart';
import 'package:flutter/foundation.dart';
import 'package:flutter/material.dart';
import 'package:flutter/services.dart';
import 'package:flutter_downloader/flutter_downloader.dart';
import 'package:flutter_locales/flutter_locales.dart';
import 'package:provider/provider.dart';
import 'package:responsive_framework/responsive_framework.dart';

Future<void> main() async {
  WidgetsFlutterBinding.ensureInitialized();
  await Firebase.initializeApp(options: DefaultFirebaseOptions.currentPlatform);
  if (!kIsWeb) {
    await FlutterDownloader.initialize();
  }

/* Initialize Hive Start */
  if (!kIsWeb) {
    final appDocumentDir = await getApplicationDocumentsDirectory();
    Hive.init(appDocumentDir.path);
    Hive.registerAdapter(DownloadItemAdapter());
    Hive.registerAdapter(ChapterItemAdapter());
    Hive.registerAdapter(EpisodeItemAdapter());
  }
/* Initialize Hive End */

  await Locales.init(['en', 'ar', 'hi']);

  SystemChrome.setPreferredOrientations([
    DeviceOrientation.portraitUp,
    DeviceOrientation.portraitDown,
  ]).then((value) {
    runApp(
      MultiProvider(
        providers: [
          ChangeNotifierProvider(create: (_) => GeneralProvider()),
          ChangeNotifierProvider(create: (_) => HomeProvider()),
          ChangeNotifierProvider(create: (_) => PlayerProvider()),
          ChangeNotifierProvider(create: (_) => ExploreProvider()),
          ChangeNotifierProvider(create: (_) => CourseDetailsProvider()),
          ChangeNotifierProvider(create: (_) => ProfileProvider()),
          ChangeNotifierProvider(create: (_) => WishlistProvider()),
          ChangeNotifierProvider(create: (_) => MyCourseProvider()),
          ChangeNotifierProvider(create: (_) => TutorProfileProvider()),
          ChangeNotifierProvider(create: (_) => ViewAllProvider()),
          ChangeNotifierProvider(create: (_) => QuizeProvider()),
          ChangeNotifierProvider(create: (_) => SearchProvider()),
          ChangeNotifierProvider(create: (_) => SubscriptionProvider()),
          ChangeNotifierProvider(create: (_) => NotificationProvider()),
          ChangeNotifierProvider(create: (_) => EbookDetailProvider()),
          ChangeNotifierProvider(create: (_) => EbookProvider()),
          ChangeNotifierProvider(create: (_) => BlogDetailProvider()),
          ChangeNotifierProvider(create: (_) => ReadBookProvider()),
          ChangeNotifierProvider(create: (_) => ThemeProvider()),
          ChangeNotifierProvider(create: (_) => VideoDownloadProvider()),
          ChangeNotifierProvider(create: (_) => ShowDownloadProvider()),
          ChangeNotifierProvider(create: (_) => VideoDownloadProvider()),
          ChangeNotifierProvider(create: (_) => VideoByIdViewAllProvider()),
          ChangeNotifierProvider(create: (_) => LiveClassProvider()),
          ChangeNotifierProvider(create: (_) => ViewSeriesProvider()),
          ChangeNotifierProvider(create: (_) => TransactionListProvider()),
          ChangeNotifierProvider(create: (_) => MeetingProvider()),
          ChangeNotifierProvider(create: (_) => AppoinmentBookingProvider()),
          ChangeNotifierProvider(create: (_) => CartProvider()),
          ChangeNotifierProvider(create: (_) => CouponProvider()),
          ChangeNotifierProvider(create: (_) => MeetingDetailsProvider()),
          ChangeNotifierProvider(create: (_) => ViewDetailsProvider()),
          ChangeNotifierProvider(create: (_) => MyWalletProvider()),
          ChangeNotifierProvider(create: (_) => ProfileEditProvider()),
          ChangeNotifierProvider(create: (_) => FeedbackProvider()),
        ],
        child: const MyApp(),
      ),
    );
  });
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  SharedPre sharedpre = SharedPre();
  late ThemeProvider themeProvider;

  @override
  void initState() {
    super.initState();
    themeProvider = Provider.of<ThemeProvider>(context, listen: false);

    if (kIsWeb) {
      getApi();
    }
  }

  Future<void> checkTheme() async {
    Constant.userID = await sharedpre.read('userid');
    Constant.isDark = await sharedpre.readBool("isdark") ?? false;
    themeProvider.changeTheme(Constant.isDark);
    /* Initialize Hive */
    if (!kIsWeb) {
      await Utils.initializeHiveBoxes();
    }
  }

  Future getApi() async {
    final profileProvider =
        Provider.of<ProfileProvider>(context, listen: false);

    final generaProvider = Provider.of<GeneralProvider>(context, listen: false);

    await generaProvider.getGeneralsetting(context);
    await generaProvider.getCategory(0);
    await profileProvider.getPages();
    await profileProvider.getSocialLink();
    if (!mounted) return;
    await profileProvider.getprofile(context);
  }

  @override
  Widget build(BuildContext context) {
    final themeProvider = Provider.of<ThemeProvider>(context);
    return LocaleBuilder(
      builder: (locale) => MaterialApp(
        /* Theme Start */
        themeMode: themeProvider.isDarkMode1 ? ThemeMode.dark : ThemeMode.light,
        theme: lightTheme,
        darkTheme: darkTheme,
        /* Theme End */
        debugShowCheckedModeBanner: false,
        localizationsDelegates: Locales.delegates,
        supportedLocales: Locales.supportedLocales,
        locale: locale,
        localeResolutionCallback:
            (Locale? locale, Iterable<Locale> supportedLocales) {
          return locale;
        },
        builder: (context, child) => ResponsiveBreakpoints.builder(
          child: child!,
          breakpoints: [
            const Breakpoint(start: 0, end: 450, name: MOBILE),
            const Breakpoint(start: 451, end: 800, name: TABLET),
            const Breakpoint(start: 801, end: 1920, name: DESKTOP),
            const Breakpoint(start: 1921, end: double.infinity, name: '4K'),
          ],
        ),
        home: (kIsWeb) ? const WebHome() : const Splash(),
        scrollBehavior: const MaterialScrollBehavior().copyWith(
          dragDevices: {
            PointerDeviceKind.mouse,
            PointerDeviceKind.touch,
            PointerDeviceKind.stylus,
            PointerDeviceKind.unknown,
            PointerDeviceKind.trackpad
          },
        ),
      ),
    );
  }
}
